using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///Optional date time picker.
		///Date will not display if set to minimum date.
		///Preferable to using little check box in standard date time picker control.
		///</summary>

		#endregion


	public class OptionalDateTimePicker : GUI.controls.BaseControl 
	{
		#region Form Controls

		private System.Windows.Forms.DateTimePicker dtpDate;
		private System.Windows.Forms.TextBox txtDate;
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		#endregion

		#region Constructors/Dispose

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// OptionalDateTimePicker class constructor
		/// </summary>
		public OptionalDateTimePicker()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
			SetComponentProperties();
			}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.dtpDate = new System.Windows.Forms.DateTimePicker();
			this.txtDate = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// dtpDate
			// 
			this.dtpDate.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.dtpDate.CustomFormat = "";
			this.dtpDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpDate.Name = "dtpDate";
			this.dtpDate.TabIndex = 0;
			this.dtpDate.TabStop = false;
			// 
			// txtDate
			// 
			this.txtDate.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.txtDate.BorderStyle = System.Windows.Forms.BorderStyle.None;
			this.txtDate.Location = new System.Drawing.Point(3, 3);
			this.txtDate.Name = "txtDate";
			this.txtDate.Size = new System.Drawing.Size(178, 13);
			this.txtDate.TabIndex = 2;
			this.txtDate.Text = "";
			// 
			// OptionalDateTimePicker
			// 
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.txtDate,
																		  this.dtpDate});
			this.Name = "OptionalDateTimePicker";
			this.Size = new System.Drawing.Size(200, 20);
			this.ResumeLayout(false);

		}
		#endregion

		#region Events/Event Handlers
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Value changed event
		/// </summary>
		public event EventHandler ValueChanged;

		/// <summary>
		/// Raises value changed event
		/// </summary>
		protected virtual void OnValueChanged()
		{
			if(ValueChanged != null)
				ValueChanged(this, EventArgs.Empty);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/10/2002</CreationDate>
		///
		///
		///<summary>
		///Gets or sets expiration date value
		///</summary>
		[
		Category("Behavior"),
		Description("Value"),
		Bindable(true),
		Browsable(true),
		]
		public DateTime Value
		{
			get
			{
				return this.dtpDate.Value;
			}
			set
			{
				if (value < this.dtpDate.MinDate)
				{
					value = this.dtpDate.MinDate;
				}
				this.dtpDate.Value = value;
				DisplayDate();
				this.OnValueChanged();
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/10/2002</CreationDate>
		///
		///<Case type="0" testid ="610"> 
		///		<ExpectedInput>An expiration date/time picker control</ExpectedInput>
		///		<ExpectedOutput>Minimum date allowed in control</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="715"> 
		///		<ExpectedInput>Valid date/time</ExpectedInput>
		///		<ExpectedOutput>An updated expiration date/time picker</ExpectedOutput>
		///	</Case>
		///
		///<summary>
		///Gets or sets the minimum expiration date selectable
		///</summary>
		[
		Category("Behavior"),
		Description("Minimum Date"),
		Bindable(true),
		Browsable(true),
		]
		public DateTime MinDate
		{
			get
			{
				return this.dtpDate.MinDate;
			}
			set
			{
				this.dtpDate.MinDate = value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/10/2002</CreationDate>
		///
		///<Case type="0" testid ="611"> 
		///		<ExpectedInput>An expiration date/time picker control</ExpectedInput>
		///		<ExpectedOutput>Maximum date allowed in control</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="716"> 
		///		<ExpectedInput>Valid date/time</ExpectedInput>
		///		<ExpectedOutput>An updated expiration date/time picker</ExpectedOutput>
		///	</Case>
		///
		/// <summary>
		/// Gets or sets the maximum expiration date selectable
		/// </summary>
		[
		Category("Behavior"),
		Description("Maximum Date"),
		Bindable(true),
		Browsable(true),
		]
		public DateTime MaxDate
		{
			get
			{
				return this.dtpDate.MaxDate;
			}
			set
			{
				this.dtpDate.MaxDate = value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///
		/// <summary>
		/// Event fired when date time picker closes. Defaults the time to 11:59 PM instead of 12:00 AM
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void dtpDate_CloseUp(object sender, System.EventArgs e)
		{
			this.dtpDate.Value = this.dtpDate.Value.Date;
			DisplayDate();
		}
		#endregion

		#region Methods
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///
		/// <summary>
		/// Private method to display the expiration date. If the date chosen is the same as the MinDate, then no date is displayed 
		/// </summary>
		private void DisplayDate()
		{
			this.OnUserActivity();

			if (dtpDate.Value == this.MinDate)
			{
				this.txtDate.Text = string.Empty;
			}
			else
			{
				this.txtDate.Text = Common.VBECSDateTime.FormatDateTimeString(this.dtpDate.Value);
			}
		}

		private void SetComponentProperties()
		{
			//set custom date and time format
			this.dtpDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value to min date
			this.dtpDate.Value = this.dtpDate.MinDate;
		}

		#endregion
	}
}
